---
title: Microsoft Azure Virtual WAN · Cloudflare One docs
description: This tutorial provides information on how to connect Magic WAN to a
  Microsoft Azure Virtual WAN hub.
lastUpdated: 2025-10-31T13:37:27.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/azure/azure-virtual-wan/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/azure/azure-virtual-wan/index.md
---

This tutorial provides information on how to connect Magic WAN to a Microsoft Azure Virtual WAN hub.

## Prerequisites

You will need to have an existing Resource group, Virtual Network, and Virtual Machine created in your Azure account. Refer to [Microsoft's documentation](https://learn.microsoft.com/en-us/azure/virtual-network/) to learn more on how to create these.

## Start Azure configuration

### 1. Create a Virtual WAN

To connect one or more VNets to Magic WAN via a Virtual WAN hub, you first need to create a Virtual WAN (vWAN) resource representing your Azure network. If you already have a vWAN that you wish to connect to Magic WAN, continue to the next step. Refer to [Microsoft's documentation](https://learn.microsoft.com/en-us/azure/virtual-wan/virtual-wan-site-to-site-portal#openvwan) to learn more.

1. In the Azure portal, go to your **Virtual WANs** page.
2. Select the option to create a **Virtual WAN**.
3. Create a Virtual WAN with the **Type** set to **Standard**.

### 2. Create a Virtual WAN Hub

Using traditional hub and spoke terminology, a Virtual WAN Hub deployed within a vWAN is the hub to which your VNet(s) and Magic WAN attach as spokes. The vWAN hub deployed in this step will contain a VPN Gateway for connecting to Magic WAN.

1. Create a **Virtual WAN Hub**.

2. In **Basics**:

   1. Select your resource group as well as your desired region, capacity, and hub routing preference. Microsoft recommends using the default hub routing preference of **ExpressRoute** unless you have a specific need to change this setting. Refer to [Microsoft's documentation](https://learn.microsoft.com/en-us/azure/virtual-wan/about-virtual-hub-routing-preference) to learn more about Azure hub routing preferences.
   2. Configure the **Hub Private Address Space**. Choose an [address space with a subnet mask of `/24` or greater](https://learn.microsoft.com/en-us/azure/virtual-wan/virtual-wan-site-to-site-portal#hub) that does not overlap with the address spaces of any VNets you wish to attach to the vWAN Hub, nor with any of your Magic WAN sites.

3. In **Site to Site**:

   1. In **Do you want to create a Site to site (VPN gateway)?** select **Yes**.
   2. Select your desired **Gateway scale units** and **Routing Preference**. Refer to [Microsoft's documentation](https://learn.microsoft.com/en-us/azure/virtual-network/ip-services/routing-preference-overview#routing-via-microsoft-global-network) to learn more about Azure routing preferences.

4. Select **Create**. Note that the deployment time for the vWAN Hub and VPN Gateway may take 30 minutes or more.

5. After the VPN Gateway has finished provisioning, go to **Virtual WAN** > **Hubs** > **Your vHub** > **Connectivity** > **VPN (Site to site)**.

6. In the **Essentials** dropdown select the VPN Gateway listed.

7. Select the JSON View for the VPN Gateway and take note of the JSON attributes at the paths `properties.ipConfigurations[0].publicIpAddress` and `properties.ipConfigurations[1].publicIpAddress`. These will be the customer endpoints needed when configuring IPsec tunnels for Magic WAN.

### 3. Create a VPN site

A VPN site represents the remote site your Azure vWAN can reach through a VPN connection. This is typically an on-premises location. In this case, the VPN site represents Magic WAN.

1. Go to **Virtual WAN** > **VPN sites** > **Create site**.

2. In **Basics**:

   1. Configure your desired region and name.
   2. Configure the **Device vendor** as Cloudflare.
   3. In **Private address space**, specify the address range(s) you wish to access from your vWAN through Magic WAN. This could include other private networks connected to your Magic WAN, or a default route (`0.0.0.0/0`) if you want Internet egress traffic to traverse Magic WAN (that is, to be scanned by Cloudflare Gateway). The address space can be modified after VPN site creation.

3. In **Links**:
   1. Configure a single link. Provide a name, speed (in Mbps), and provider name (here, enter `Cloudflare`) for your link. For the **Link IP address**, enter your Cloudflare anycast address. The **BGP address** and **ASN** fields should be left empty. BGP is not supported at the time of writing this tutorial.

4. Select **Create**.

### 4. Configure VPN site for Magic IPsec tunnel health checks

Magic WAN uses [Tunnel Health Checks](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/reference/tunnel-health-checks/) to monitor whether a tunnel is available.

Tunnel health checks make use of ICMP probes sent from the Cloudflare side of the Magic IPsec tunnel to the remote endpoint (Azure). Probes are sent from the tunnel's interface address, which you specify in two places:

* **Cloudflare Dashboard:** In your Magic IPsec tunnel configuration as the address of the virtual tunnel interface (VTI) (so that Cloudflare knows what address to send probes from). Cloudflare requires this address in CIDR notation with a `/31` netmask.
* **Azure Portal:** In your VPN site's address space (so that Azure routes probe responses back over the tunnel). Azure requires this address in CIDR notation with a `/32` netmask.

Cloudflare recommends that you select a unique `/31` subnet ([RFC 1918 — Address Allocation for Private Internets](https://datatracker.ietf.org/doc/html/rfc1918)) for each IPsec tunnel which is treated as a Point-to-Point Link and provides the ideal addressing scheme to satisfy both requirements.

Example:

* Select `169.254.251.137/31` as your unique Point-to-Point Link subnet.
* In the Cloudflare dashboard, set `169.254.251.137/31` as your tunnel's **IPv4 Interface address**. (Refer to [Configure Magic WAN](#configure-magic-wan) below.)
* In the Azure portal, add `169.254.251.137/32` to your VPN site's **Private address space**.

Note

It is important to ensure the subnet selected for the Interface Address does not overlap with any other subnet.

You should also refer to RFC 3021 for more information on using 31-bit prefixes on [IPv4 Point-to-Point Links](https://datatracker.ietf.org/doc/html/rfc3021).

To configure the Address Space for the Local Network Gateway to support Tunnel Health Checks:

1. Go to **Virtual WAN** > **VPN sites** > **Your VPN Site** > **Edit site** to edit the VPN site configured in the previous section.
2. Update the **Private address space** to include two `/32` subnets in CIDR notation as described above. When using Azure VPN Gateways with vWAN Hubs, a single VPN Gateway Connection maps to two Magic WAN IPsec Tunnels. For this reason, we need to select two unique `/31` subnets, one for each Cloudflare IPsec Tunnel. The upper address of each `/31` is then added to the VPN Site's Private address space as a `/32`subnet.
3. Select **Confirm**.

### 5. Create a Virtual Network Connection

To connect your existing VNet to your newly created vHub:

1. Go to **Virtual WAN** > **Virtual network connections** and select **Add connection**.

2. Configure the connection to connect the desired VNet to the vHub created above.

3. Ensure that within the connection's **Routing configuration**:

   1. **Propagate to none** is set to **No.**
   2. **Bypass Next Hop IP for workloads within this VNet** is set to **No**
   3. And **Propagate static route** is set to **Yes**.

4. Select **Create**.

## Configure Magic WAN

When connecting your Azure vHub VPN Gateway to Magic WAN, you need to create two Magic WAN IPsec tunnels to map to the single Azure VPN Gateway Connection created above. This is because Azure VPN Gateways are deployed with two public IP addresses.

1. Create an [IPsec tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/how-to/configure-tunnel-endpoints/#add-tunnels) in the Cloudflare dashboard.

2. Make sure you have the following settings:

   1. **Interface address**: Add the upper IP address within the first `/31` subnet selected in step 4 of the Start Azure Configuration section. Refer to [Tunnel endpoints](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/how-to/configure-tunnel-endpoints/) for more details.
   2. **Customer endpoint**: The first public IP associated with your Azure VPN Gateway. For example, `40.xxx.xxx.xxx`.
   3. **Cloudflare endpoint**: Use the Cloudflare anycast address you have received from your account team. This will also be the IP address corresponding to the VPN Site in Azure. For example, `162.xxx.xxx.xxx`.
   4. **Health check rate**: Medium (default).
   5. **Health check type**: Reply (default).
   6. **Health check direction**: Bidirectional (default).
   7. **Health check target**: Custom; enter the customer endpoint.
   8. **Add pre-shared key later**: Select this option to create a PSK that will be used later in Azure.
   9. **Replay protection**: **Enable**.

3. Edit the tunnel. Generate a new pre-shared key and copy the key to a safe location.

4. Create static routes for your Azure Virtual Network subnets, specifying the newly created tunnel as the next hop.

5. Create the second IPsec tunnel in the Cloudflare dashboard. Copy the configuration of the first tunnel with the following exceptions:

   1. **Interface address**: Add the upper IP address within the **second** `/31` subnet selected in step 4 of the Start Azure Configuration section.
   2. **Customer endpoint**: The **second** Public IP associated with your Azure VPN Gateway.
   3. **Health check target**: Enter the new customer endpoint as a custom target.
   4. **Use my own pre-shared key**: Select this option and enter the key generated for the first tunnel.

6. Create static routes for your Azure Virtual Network subnets, specifying the newly created tunnel as the next hop. To use one tunnel as primary and the other as backup, give the primary tunnel's route a lower priority. To ECMP load balance across both tunnels, assign both routes the same priority.

## Finish Azure Configuration

### 1. Create an IPsec VPN Gateway Connection

To create a **VPN Gateway Connection**:

1. Go to **Virtual WAN** > **Hubs** > **Your vHub** > **Connectivity** > **VPN (Site to site)** and remove the default filter **Hub association: Connected** to display the **VPN Site** created above.
2. Check the box next to your VPN Site and select **Connect VPN sites**.

Choose the following settings. These settings have been tested by Cloudflare. However, when setting up your VPN connection note that there are other configuration parameters are also technically feasible, as documented in the [Azure documentation](https://learn.microsoft.com/en-us/azure/virtual-wan/virtual-wan-ipsec) and in the [Cloudflare documentation](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/reference/gre-ipsec-tunnels/#supported-configuration-parameters).

1. **PSK**: Provide the PSK generated by Cloudflare for your Magic WAN Tunnels.

2. **Protocol**: *IKEv2*

3. **IPsec**: *Custom*

   1. **IPsec SA lifetime in seconds**: 28800

   2. **IKE Phase 1**

      1. **Encryption**: *AES256*
      2. **Integrity/PRF**: *SHA256*
      3. **DH Group**: *ECP384*

   3. **IKE Phase 2(IPsec)**

      1. **IPsec Encryption**: *AES256*
      2. **IPsec Integrity**: *SHA256*
      3. **PFS Group**: *ECP384*

   4. **Propagate Default Route:** **Disable**

   5. **Use policy based traffic selector**: **Disable**

   6. **Connection mode**: **Initiator Only**

   7. **Configure traffic selector?**: **Disabled**

4. Select **Connect**.
