---
title: Concepts · Cloudflare Learning Paths
description: The goal of this learning path is to provide Cloudflare One users
  with the strategy and tools to securely adopt generative AI within their
  organizations. This guide will help address new security challenges and
  mitigate risks like shadow AI and data loss.
lastUpdated: 2025-08-26T10:01:18.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/holistic-ai-security/concepts/
  md: https://developers.cloudflare.com/learning-paths/holistic-ai-security/concepts/index.md
---

The goal of this learning path is to provide Cloudflare One users with the strategy and tools to securely adopt generative AI within their organizations. This guide will help address new security challenges and mitigate risks like shadow AI and data loss.

## Objectives

* Determine risk tolerance: Identify areas of concern and risk tolerance for AI use to establish a baseline for your organization's AI security strategy.
* Monitor AI usage: Utilize Cloudflare One's tools, such as the Shadow IT dashboard and API CASB integrations, to gain visibility into both sanctioned and unsanctioned AI application usage.
* Build security policies: Create granular security policies using Cloudflare Gateway to control AI usage, prevent data loss with DLP, and manage user behavior through actions like blocking or redirecting.
* Secure sanctioned models: Apply Zero Trust principles to sanctioned AI models and internal services like Model Context Protocol (MCP) servers to ensure secure access and protect sensitive data from being exposed.
