---
title: Malicious script and connection detection · Cloudflare Page Shield docs
description: Page Shield implements different mechanisms to determine if a
  script or a connection is malicious.
lastUpdated: 2025-07-10T11:20:10.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/page-shield/how-it-works/malicious-script-detection/
  md: https://developers.cloudflare.com/page-shield/how-it-works/malicious-script-detection/index.md
---

Note

This feature is available as a paid add-on for customers on an Enterprise plan.

Cloudflare uses different mechanisms to determine if a script, or a connection made by a script, is malicious. These mechanisms are:

* Malicious script detection
* Malicious URL checks
* Malicious domain checks

Any updates to the threat feeds will trigger new checks for previously detected scripts or connections so that the client-side resource monitoring dashboards always reflect the latest categorization.

## Malicious script detection

In this type of detection, Cloudflare will download the script file and run it through a classifier. The classifier is a machine learning (ML) model that has learned to detect patterns of malicious operations such as [Magecart-type attacks](https://sansec.io/what-is-magecart).

The script classifier will output a probability score for the script (also called the JS integrity score) between 1 and 99, where 1 means definitely malicious and 99 means definitely not malicious. This score, together with a threshold value, will determine if the malicious script detection system will classify the script as malicious or not.

The score threshold for considering a script as malicious is currently set to 10. If the script classification score is below this value, the monitoring dashboards will display the script as being malicious.

In addition to the integrity score, Cloudflare will also provide individual scores for different malicious code detections (scores from 1 to 99):

* **Magecart**
* **Crypto mining**
* **Malware**

You can [configure Malicious Script Alerts](https://developers.cloudflare.com/page-shield/alerts/configure/) to receive an alert notification as soon as Cloudflare detects JavaScript code classified as malicious in your domain.

## Malicious URL checks

Cloudflare will search for the URLs of your JavaScript dependencies in threat intelligence feeds to determine if any of those scripts should be categorized as malicious.

The client-side resource monitoring dashboards display the scripts that were considered malicious at the top of the scripts list.

You can [configure Malicious URL Alerts](https://developers.cloudflare.com/page-shield/alerts/configure/) to receive an alert notification as soon as Cloudflare detects a script from a malicious URL in your domain.

Depending on your current configuration, Cloudflare can also search for malicious URLs in the URLs of outgoing connections made by scripts in your domain. To enable this check, you must [allow resource monitoring to use the full URLs of outgoing connections](https://developers.cloudflare.com/page-shield/reference/settings/#connection-target-details) instead of only the hostname in the settings page.

## Malicious domain checks

Cloudflare will search for the domains of your client-side JavaScript dependencies in threat feeds to determine if any of those scripts is being served from a known malicious domain.

A domain previously reported as malicious can later be reported as non-malicious if, after further analysis, the domain is deemed safe.

Cloudflare will also check the target domains of connections made by scripts in your domain's pages, following the same approach described for scripts.

You can [configure Malicious Domain Alerts](https://developers.cloudflare.com/page-shield/alerts/configure/) to receive an alert notification as soon as Cloudflare detects a malicious script loaded from a known malicious domain in your domain.

***

## Malicious script and connection categories

Scripts and connections considered malicious are categorized based on data from threat intelligence feeds. The current categories are the following:

* Security threats
* Command-and-Control (C2) & Botnet
* Crypto mining
* Spyware
* Phishing
* Malware
* Domain Generation Algorithm (DGA) domain
* Typosquatting & Impersonation

Each script or connection considered malicious can belong to several categories.
